/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCFrameClient;
import com.ibm.hsc.client.PIHSCSysClient;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class PIInitDumpCommand {
    private static final int NUM_VALID_PARMS = 6;
    private String m_managedSystem;
    private String m_frame;
    private String m_side;
    private String m_type;
    private String m_lparId;
    private String m_lparName;
    private boolean m_hasId;
    private int m_lparIdInt = 0;
    private boolean m_hasName;
    private final String TYPE_POWER_SUBSYSTEM = "pss";
    private HashMap m_validParms = new HashMap(13, 0.5f);
    private PIHSCCECClient m_CECClient = null;
    private PIHSCFrameClient m_FrameClient = null;
    private PrintStream m_out;
    private boolean m_writeStatus;

    private PIInitDumpCommand(PIHSCFrameClient pIHSCFrameClient, PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_FrameClient = pIHSCFrameClient;
        this.m_CECClient = pIHSCCECClient;
        this.m_out = printStream;
        this.m_writeStatus = bl;
        this.m_validParms.put("-m", null);
        this.m_validParms.put("-t", null);
        this.m_validParms.put("-p", null);
        this.m_validParms.put("--id", null);
        this.m_validParms.put("-e", null);
        this.m_validParms.put("-s", null);
    }

    private PIHSCSysClient createSysClient() throws PIHscClientException {
        String string = "";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string, null);
        PIHSCSysClient pIHSCSysClient = null;
        if (this.m_CECClient != null) {
            pIHSCSysClient = pIHSCClientObjectFactory.createSysClient(this.m_managedSystem, false, 0);
        } else if (this.m_FrameClient != null) {
            pIHSCSysClient = pIHSCClientObjectFactory.createSysClient(this.m_frame, false, 1);
        }
        if (null == pIHSCSysClient) {
            if (this.m_CECClient == null) {
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8002", null, null);
            }
            if (this.m_FrameClient == null) {
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8001", null, null);
            }
            return null;
        }
        return pIHSCSysClient;
    }

    private int doInitializeDump() throws PIHscClientException {
        int n = 0;
        Vector vector = null;
        String string = null;
        Object var4_4 = null;
        String[] stringArray = null;
        if (!this.m_type.equals("fhd")) {
            String string2 = null;
            if (!this.m_type.equals("pss")) {
                string2 = this.m_type.equals("sys") ? HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "STARTDUMP_SYS_DUMP_CONFIRMATION") : HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "STARTDUMP_SP_DUMP_CONFIRMATION");
            }
            boolean bl = false;
            if (string2 != null) {
                bl = PIHMCCommandUtils.doConfirmation(string2);
            }
            if (bl || this.m_type.equals("pss")) {
                PIHSCSysClient pIHSCSysClient = this.createSysClient();
                if (pIHSCSysClient != null) {
                    String string3 = "PRIMARY";
                    if (this.m_frame != null && "a".equals(this.m_side)) {
                        string3 = "SIDE_A";
                    } else if (this.m_frame != null && "b".equals(this.m_side)) {
                        string3 = "SIDE_B";
                    }
                    if (this.m_type.equals("sys")) {
                        pIHSCSysClient.initializeDump(string3);
                    } else if (this.m_type.equals("sp") || this.m_type.equals("pss")) {
                        pIHSCSysClient.initializeSPDump(string3);
                    }
                    n = 0;
                }
            } else {
                n = 1;
            }
        } else {
            if (this.m_hasName && (vector = this.m_CECClient.getPartitionNames()) != null) {
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    stringArray = (String[])iterator.next();
                    if (!this.m_lparName.equals(stringArray[1])) continue;
                    string = stringArray[0];
                    if (string == null) break;
                    string = string.substring(0, string.indexOf("*"));
                    this.m_lparIdInt = Integer.parseInt(string, 10);
                    break;
                }
            }
            if (this.m_lparIdInt > 0) {
                this.m_CECClient.initFireHoseDump(this.m_lparIdInt);
            }
        }
        return n;
    }

    private int performCommand() throws PIHscClientException {
        PICECDataBean pICECDataBean;
        int n;
        int n2 = 0;
        this.checkParameters();
        if (this.m_CECClient != null && ((n = (pICECDataBean = this.m_CECClient.getCECDataBean(new String[]{"state"})).getCecState().intValue()) == 254 || n == 241 || n == 242 || n == 250)) {
            String[] stringArray = new String[]{pICECDataBean.getCECStateString()};
            throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0237", stringArray, null);
        }
        n2 = this.doInitializeDump();
        if (this.m_writeStatus) {
            if (n2 == 0) {
                this.m_out.write(0);
            } else {
                this.m_out.write(1);
            }
        }
        return n2;
    }

    private void checkParameters() throws PIHscClientException {
        String[] stringArray = null;
        String string = "";
        if (this.m_type == null || !"sys".equals(this.m_type) && !"pss".equals(this.m_type) && !"fhd".equals(this.m_type) && !"sp".equals(this.m_type)) {
            string = string + ", -t";
        }
        if (this.m_frame != null && (this.m_side == null || !"a".equals(this.m_side.toLowerCase()) && !"b".equals(this.m_side.toLowerCase()))) {
            string = string + ", -s";
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (this.m_managedSystem != null && this.m_side != null) {
            string = "-s";
        }
        if (this.m_frame != null && !"pss".equals(this.m_type)) {
            string = "-e";
        }
        if (this.m_managedSystem != null && "pss".equals(this.m_type)) {
            string = "-m";
        }
        if (string.length() > 0) {
            stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_COMBINATION", stringArray, null);
        }
        if (!"fhd".equals(this.m_type)) {
            string = "";
            if (this.m_lparName != null) {
                string = string + ", -p";
            }
            if (this.m_lparId != null) {
                string = string + ", --id";
            }
            if (string.length() > 0) {
                if (string.startsWith(", ")) {
                    string = string.substring(2, string.length());
                }
                stringArray = new String[]{string};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM", stringArray, null);
            }
        } else {
            this.m_hasId = this.m_lparId != null;
            boolean bl = this.m_hasName = this.m_lparName != null;
            if (this.m_hasId && this.m_hasName) {
                stringArray = new String[]{"[--id | -p]"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_PARMS", stringArray, null);
            }
            if (!this.m_hasId && !this.m_hasName) {
                stringArray = new String[]{"--id | -p"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
            if (this.m_hasId) {
                try {
                    this.m_lparIdInt = Integer.parseInt(this.m_lparId, 10);
                }
                catch (NumberFormatException numberFormatException) {
                    stringArray = new String[]{"--id"};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
                }
            }
        }
    }

    private void mapParameters(HashMap hashMap) {
        this.m_managedSystem = (String)hashMap.get("-m");
        this.m_type = (String)hashMap.get("-t");
        this.m_lparId = (String)hashMap.get("--id");
        this.m_lparName = (String)hashMap.get("-p");
        this.m_side = (String)hashMap.get("-s");
        this.m_frame = (String)hashMap.get("-e");
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.write(0);
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "STARTDUMP_HELP_GA3"));
    }

    public static int callCommandFromRouter(PIHSCFrameClient pIHSCFrameClient, PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PIInitDumpCommand pIInitDumpCommand = new PIInitDumpCommand(pIHSCFrameClient, pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pIInitDumpCommand.m_validParms);
            pIInitDumpCommand.mapParameters(hashMap);
            n = pIInitDumpCommand.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
            }
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
            }
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

